/* ResistorDA
 * Resistor color-bar calcurater (Desk Accessory)
 *
 * by TERADA, Koichi
 * email: kterada@iname.com
 * web:   http://www04.u-page.so-net.ne.jp/zd5/kterada/
 * Sept. 1999
 */

#include <Pilot.h>
#include <Common.h>
#include <System/SysAll.h>
#include <UI/UIAll.h>
#include <Hardware/Hardware.h>
#include <UI/ScrDriverNew.h>
#include <International/CharLatin.h>

#include "ResistorDA_res.h"
#include "ResistorDA.h"

void start()
{
	FormPtr		form;
	VoidHand	handle;
	Param		*param;
	DWord		featureValue;

	if( ! isColorDevice() ) {
		FrmAlert( NoColorAlert );
		return;
	}

	if( FtrGet( ResistorDA_AppID, 0, &featureValue ) == 0 ) {
		FrmAlert( QuitAlert );
		return;
	}
	FtrSet( ResistorDA_AppID, 0, 0 );
	
	handle = MemHandleNew( sizeof( Param ));
	param = MemHandleLock( handle );
	LoadFromPrefs( param );
	getColorBars( param );
	
	form = FrmInitForm( MainForm );
	FrmSetActiveForm( form );
	FrmDrawForm( form );
	setAndDrawFields( param );
	EventMainLoop( param );
	FrmEraseForm( form );
	FrmDeleteForm( form );

	releaseColorBars( param );
	SaveToPrefs( param );
	MemHandleUnlock( handle );
	MemHandleFree( handle );
	FtrUnregister( ResistorDA_AppID, 0 );
}

static int EventMainLoop( Param *param )
{
	EventType event;
	Word error;
	Boolean done = false;
	
	do {
		EvtGetEvent (&event, -1);
		if (! SysHandleEvent (&event))
			if (! MenuHandleEvent (NULL, &event, &error)) {
				if ( !FrmHandleEvent(FrmGetActiveForm(), &event))
					done = HandleMainEvent(&event, param);
			}
	} while ((event.eType != appStopEvent) && !done);
	
	return done;
}

static Boolean HandleMainEvent(EventPtr event, Param *param)
{
	Boolean handled = false;
	Boolean done = false;
	Word ch;
	//char str[10];
	
	switch (event->eType) {
		case appStopEvent:
			EvtAddEventToQueue(event);
			done= true;
			handled = true;
			break;
		
		case ctlSelectEvent:
			handled = true;
			switch (event->data.ctlSelect.controlID) {
				case mainButtonDone:
					done = true;
					break;
				case mainButton4Lines:
					param->bands = BANDS_4BANDS;
					setAndDrawFields( param );
					break;
				case mainButton5Lines:
					param->bands = BANDS_5BANDS;
					setAndDrawFields( param );
					break;
			//	case mainPushButton0_0:
				case mainPushButton0_1:
				case mainPushButton0_2:
				case mainPushButton0_3:
				case mainPushButton0_4:
				case mainPushButton0_5:
				case mainPushButton0_6:
				case mainPushButton0_7:
				case mainPushButton0_8:
				case mainPushButton0_9:
					param->band_1 = (event->data.ctlSelect.controlID - mainPushButton0_0) ;
					updateResistorSymbol( param );
					break;
				case mainPushButton1_0:
				case mainPushButton1_1:
				case mainPushButton1_2:
				case mainPushButton1_3:
				case mainPushButton1_4:
				case mainPushButton1_5:
				case mainPushButton1_6:
				case mainPushButton1_7:
				case mainPushButton1_8:
				case mainPushButton1_9:
					param->band_2 = (event->data.ctlSelect.controlID - mainPushButton1_0) ;
					updateResistorSymbol( param );
					break;
				case mainPushButton2_0:
				case mainPushButton2_1:
				case mainPushButton2_2:
				case mainPushButton2_3:
				case mainPushButton2_4:
				case mainPushButton2_5:
				case mainPushButton2_6:
				case mainPushButton2_7:
				case mainPushButton2_8:
				case mainPushButton2_9:
					param->band_3 = (event->data.ctlSelect.controlID - mainPushButton2_0) ;
					updateResistorSymbol( param );
					break;
				case mainPushButton3_0:
				case mainPushButton3_1:
				case mainPushButton3_2:
				case mainPushButton3_3:
				case mainPushButton3_4:
				case mainPushButton3_5:
				case mainPushButton3_6:
				case mainPushButton3_7:
				case mainPushButton3_8:
				case mainPushButton3_9:
				case mainPushButton3_10:
				case mainPushButton3_11:
					param->band_4 = (event->data.ctlSelect.controlID - mainPushButton3_0) ;
					updateResistorSymbol( param );
					break;
				case mainPushButton4_0:
				case mainPushButton4_1:
				case mainPushButton4_2:
				case mainPushButton4_3:
					param->band_5 = (event->data.ctlSelect.controlID - mainPushButton4_0) ;
					updateResistorSymbol( param );
					break;

				default:
					handled = false;
					break;
			}
			break;
		
		case penDownEvent: {
			SWord x,y;
			x = event->screenX;
			y = event->screenY;
			WinWindowToDisplayPt(&x, &y);
			if (y > 0 && y < mainFormTop) {
				done = true;
			}
			handled = true;
			break;
		}

		case keyDownEvent:
			ch = event->data.keyDown.chr;
			if (chrIsHardKey(ch)) {
			/* maybe 'HotSync!' button pressed ? */
				EvtAddEventToQueue(event);
				done = true;
				handled = true;
			}
			break;
		
		
		default:
			break;
	}
	return done;
}

static void getColorBars( Param *param )
{
	Word i;

	for( i = 0 ; i < 13 ; i ++ ) {
		param->dataRsrcH[i] = DmGet1Resource( 'Tbmp', 9000 + i );
		param->colorbarP[i] = MemHandleLock( param->dataRsrcH[i] );
	}
	return;
}

static void releaseColorBars( Param *param )
{
	Word i;

	for( i = 0 ; i < 13 ; i ++ ) {
		MemHandleUnlock( param->dataRsrcH[i] );
		DmReleaseResource( param->dataRsrcH[i] );
	}
	return;
}

static void updateResistorSymbol( Param *param )
{
	WinDrawBitmap( (BitmapPtr)(param->colorbarP[ param->band_1 ]), ResistorSymbolLeft, ResistorBand1Top );
	WinDrawBitmap( (BitmapPtr)(param->colorbarP[ param->band_2 ]), ResistorSymbolLeft, ResistorBand2Top );
	if( param->bands == BANDS_5BANDS ) {
		WinDrawBitmap( (BitmapPtr)(param->colorbarP[ param->band_3 ]), ResistorSymbolLeft, ResistorBand3Top );
		WinDrawBitmap( (BitmapPtr)(param->colorbarP[ param->band_4 ]), ResistorSymbolLeft, ResistorBand4Top );
	} else {
		WinDrawBitmap( (BitmapPtr)(param->colorbarP[ param->band_4 ]), ResistorSymbolLeft, ResistorBand3Top );
		WinDrawBitmap( (BitmapPtr)(param->colorbarP[ BAND_NULL ]), ResistorSymbolLeft, ResistorBand4Top );
	}

	switch( param->band_5 ) {
	case BAND5_BROWN:
		WinDrawBitmap( (BitmapPtr)(param->colorbarP[ BAND_BROWN ]), ResistorSymbolLeft, ResistorBand5Top );
		break;
	case BAND5_RED:
		WinDrawBitmap( (BitmapPtr)(param->colorbarP[ BAND_RED ]), ResistorSymbolLeft, ResistorBand5Top );
		break;
	case BAND5_GOLD:
		WinDrawBitmap( (BitmapPtr)(param->colorbarP[ BAND_GOLD ]), ResistorSymbolLeft, ResistorBand5Top );
		break;
	case BAND5_SILVER:
		WinDrawBitmap( (BitmapPtr)(param->colorbarP[ BAND_SILVER ]), ResistorSymbolLeft, ResistorBand5Top );
		break;
	}

	updateResultField( param );

	return;
}

static void frmSetObjectValue( FormPtr form, Word id, Boolean value )
{
    FrmSetControlValue( form, FrmGetObjectIndex(form, id ), value ); 
    return;
}

static void setAndDrawFields( Param *param )
{
//	FieldPtr fieldptr;
	FormPtr form;
	Word offset;
	
	form = FrmGetActiveForm();

	if( param->bands == BANDS_4BANDS ) {
		frmSetObjectValue( form, mainButton4Lines, 1 );
		frmSetObjectValue( form, mainButton5Lines, 0 );
		hideThirdBand( param, form );
	} else {
		frmSetObjectValue( form, mainButton4Lines, 0 );
		frmSetObjectValue( form, mainButton5Lines, 1 );
		showThirdBand( param, form );
	}

	for( offset = 1 ; offset < 10 ; offset ++ ) {
		if( param->band_1 == offset ) {
			frmSetObjectValue( form, mainPushButton0_0 + offset, 1 );
		} else {
			frmSetObjectValue( form, mainPushButton0_0 + offset, 0 );
		}
	}
	for( offset = 0 ; offset < 10 ; offset ++ ) {
		if( param->band_2 == offset ) {
			frmSetObjectValue( form, mainPushButton1_0 + offset, 1 );
		} else {
			frmSetObjectValue( form, mainPushButton1_0 + offset, 0 );
		}
	}
	if( param->bands == BANDS_5BANDS ) {
			for( offset = 0 ; offset < 10 ; offset ++ ) {
				if( param->band_3 == offset ) {
					frmSetObjectValue( form, mainPushButton2_0 + offset, 1 );
				} else {
					frmSetObjectValue( form, mainPushButton2_0 + offset, 0 );
				}
			}
	}
	for( offset = 0 ; offset < 12 ; offset ++ ) {
		if( param->band_4 == offset ) {
			frmSetObjectValue( form, mainPushButton3_0 + offset, 1 );
		} else {
			frmSetObjectValue( form, mainPushButton3_0 + offset, 0 );
		}
	}
	for( offset = 0 ; offset < 4 ; offset ++ ) {
		if( param->band_5 == offset ) {
			frmSetObjectValue( form, mainPushButton4_0 + offset, 1 );
		} else {
			frmSetObjectValue( form, mainPushButton4_0 + offset, 0 );
		}
	}

//	FrmDrawForm( form );	
	updateResistorSymbol( param );

	return;
}

static void updateResultField( Param *param )
{
	FieldPtr fieldptr;
	FormPtr form;
	
	formatResistorValue( param );

	form = FrmGetActiveForm();

	fieldptr = FrmGetObjectPtr(form, FrmGetObjectIndex(form, mainFieldResult));
	FldSetTextPtr(fieldptr, param->resultStr);
	FldRecalculateField(fieldptr, true);
	FldDrawField( fieldptr );

	fieldptr = FrmGetObjectPtr(form, FrmGetObjectIndex(form, mainFieldError));
	FldSetTextPtr(fieldptr, param->errorStr);
	FldRecalculateField(fieldptr, true);
	FldDrawField( fieldptr );

	return;
}

static void formatResistorValue( Param *param )
{
	Char *p;

	p = param->resultStr;
	switch( param->band_4 ) {
	case BAND_BLACK:
		if( param->bands == BANDS_5BANDS ) {
			*(p ++) = '0' + param->band_1;
			*(p ++) = '0' + param->band_2;
			*(p ++) = '0' + param->band_3;
		} else {
			*(p ++) = '0' + param->band_1;
			*(p ++) = '0' + param->band_2;
		}
		break;
	case BAND_BROWN:
		if( param->bands == BANDS_5BANDS ) {
			*(p ++) = '0' + param->band_1;
			*(p ++) = '.';
			*(p ++) = '0' + param->band_2;
			*(p ++) = '0' + param->band_3;
			*(p ++) = 'k';
		} else {
			*(p ++) = '0' + param->band_1;
			*(p ++) = '0' + param->band_2;
			*(p ++) = '0';
		}
		break;
	case BAND_RED:
		if( param->bands == BANDS_5BANDS ) {
			*(p ++) = '0' + param->band_1;
			*(p ++) = '0' + param->band_2;
			*(p ++) = '.';
			*(p ++) = '0' + param->band_3;
			*(p ++) = 'k';
		} else {
			*(p ++) = '0' + param->band_1;
			*(p ++) = '.';
			*(p ++) = '0' + param->band_2;
			*(p ++) = 'k';
		}
		break;
	case BAND_ORANGE:
		if( param->bands == BANDS_5BANDS ) {
			*(p ++) = '0' + param->band_1;
			*(p ++) = '0' + param->band_2;
			*(p ++) = '0' + param->band_3;
			*(p ++) = 'k';
		} else {
			*(p ++) = '0' + param->band_1;
			*(p ++) = '0' + param->band_2;
			*(p ++) = 'k';
		}
		break;
	case BAND_YELLOW:
		if( param->bands == BANDS_5BANDS ) {
			*(p ++) = '0' + param->band_1;
			*(p ++) = '.';
			*(p ++) = '0' + param->band_2;
			*(p ++) = '0' + param->band_3;
			*(p ++) = 'M';
		} else {
			*(p ++) = '0' + param->band_1;
			*(p ++) = '0' + param->band_2;
			*(p ++) = '0';
			*(p ++) = 'k';
		}
		break;
	case BAND_GREEN:
		if( param->bands == BANDS_5BANDS ) {
			*(p ++) = '0' + param->band_1;
			*(p ++) = '0' + param->band_2;
			*(p ++) = '.';
			*(p ++) = '0' + param->band_3;
			*(p ++) = 'M';
		} else {
			*(p ++) = '0' + param->band_1;
			*(p ++) = '.';
			*(p ++) = '0' + param->band_2;
			*(p ++) = 'M';
		}
		break;
	case BAND_BLUE:
		if( param->bands == BANDS_5BANDS ) {
			*(p ++) = '0' + param->band_1;
			*(p ++) = '0' + param->band_2;
			*(p ++) = '0' + param->band_3;
			*(p ++) = 'M';
		} else {
			*(p ++) = '0' + param->band_1;
			*(p ++) = '0' + param->band_2;
			*(p ++) = 'M';
		}
		break;
	case BAND_VIOLET:
		if( param->bands == BANDS_5BANDS ) {
			*(p ++) = '0' + param->band_1;
			*(p ++) = '.';
			*(p ++) = '0' + param->band_2;
			*(p ++) = '0' + param->band_3;
			*(p ++) = 'G';
		} else {
			*(p ++) = '0' + param->band_1;
			*(p ++) = '0' + param->band_2;
			*(p ++) = '0';
			*(p ++) = 'M';
		}
		break;
	case BAND_GRAY:
		if( param->bands == BANDS_5BANDS ) {
			*(p ++) = '0' + param->band_1;
			*(p ++) = '0' + param->band_2;
			*(p ++) = '.';
			*(p ++) = '0' + param->band_3;
			*(p ++) = 'G';
		} else {
			*(p ++) = '0' + param->band_1;
			*(p ++) = '.';
			*(p ++) = '0' + param->band_2;
			*(p ++) = 'G';
		}
		break;
	case BAND_WHITE:
		if( param->bands == BANDS_5BANDS ) {
			*(p ++) = '0' + param->band_1;
			*(p ++) = '0' + param->band_2;
			*(p ++) = '0' + param->band_3;
			*(p ++) = 'G';
		} else {
			*(p ++) = '0' + param->band_1;
			*(p ++) = '0' + param->band_2;
			*(p ++) = 'G';
		}
		break;
	case BAND_GOLD:
		if( param->bands == BANDS_5BANDS ) {
			*(p ++) = '0' + param->band_1;
			*(p ++) = '0' + param->band_2;
			*(p ++) = '.';
			*(p ++) = '0' + param->band_3;
		} else {
			*(p ++) = '0' + param->band_1;
			*(p ++) = '.';
			*(p ++) = '0' + param->band_2;
		}
		break;
	case BAND_SILVER:
		if( param->bands == BANDS_5BANDS ) {
			*(p ++) = '0' + param->band_1;
			*(p ++) = '.';
			*(p ++) = '0' + param->band_2;
			*(p ++) = '0' + param->band_3;
		} else {
			*(p ++) = '0';
			*(p ++) = '.';
			*(p ++) = '0' + param->band_1;
			*(p ++) = '0' + param->band_2;
		}
		break;
	}

	*(p ++) = '\0';
	p = param->errorStr;

	switch( param->band_5 ) {
	case BAND5_BROWN:
		*(p ++) = '1';
		break;
	case BAND5_RED:
		*(p ++) = '2';
		break;
	case BAND5_GOLD:
		*(p ++) = '5';
		break;
	case BAND5_SILVER:
		*(p ++) = '1';
		*(p ++) = '0';
		break;
	}
	*(p ++) = '%';
	*(p ++) = '\0';

	return;
}

static void showThirdBand( Param *param, FormPtr form )
{
	FrmShowObject( form, FrmGetObjectIndex(form, mainPushButton2_0) );
	FrmShowObject( form, FrmGetObjectIndex(form, mainPushButton2_1) );
	FrmShowObject( form, FrmGetObjectIndex(form, mainPushButton2_2) );
	FrmShowObject( form, FrmGetObjectIndex(form, mainPushButton2_3) );
	FrmShowObject( form, FrmGetObjectIndex(form, mainPushButton2_4) );
	FrmShowObject( form, FrmGetObjectIndex(form, mainPushButton2_5) );
	FrmShowObject( form, FrmGetObjectIndex(form, mainPushButton2_6) );
	FrmShowObject( form, FrmGetObjectIndex(form, mainPushButton2_7) );
	FrmShowObject( form, FrmGetObjectIndex(form, mainPushButton2_8) );
	FrmShowObject( form, FrmGetObjectIndex(form, mainPushButton2_9) );
	return;
}

static void hideThirdBand( Param *param, FormPtr form )
{
	FrmHideObject( form, FrmGetObjectIndex(form, mainPushButton2_0) );
	FrmHideObject( form, FrmGetObjectIndex(form, mainPushButton2_1) );
	FrmHideObject( form, FrmGetObjectIndex(form, mainPushButton2_2) );
	FrmHideObject( form, FrmGetObjectIndex(form, mainPushButton2_3) );
	FrmHideObject( form, FrmGetObjectIndex(form, mainPushButton2_4) );
	FrmHideObject( form, FrmGetObjectIndex(form, mainPushButton2_5) );
	FrmHideObject( form, FrmGetObjectIndex(form, mainPushButton2_6) );
	FrmHideObject( form, FrmGetObjectIndex(form, mainPushButton2_7) );
	FrmHideObject( form, FrmGetObjectIndex(form, mainPushButton2_8) );
	FrmHideObject( form, FrmGetObjectIndex(form, mainPushButton2_9) );
	return;
}

static void LoadFromPrefs( Param *param )
{
	SWord prefsVersion;
	ResistorDAPreferenceType prefs;
	Word prefsSize;
	int availPrefs;
	SystemPreferencesType sysPrefs;
	
	PrefGetPreferences( &sysPrefs );	
	prefsSize = sizeof (ResistorDAPreferenceType);
	prefsVersion = PrefGetAppPreferences( ResistorDA_AppID, 0, &prefs, &prefsSize, true );
	availPrefs = ( prefsVersion == ResistorDAPrefVersionNum );
	if( ! availPrefs ) {
		param->bands = BANDS_4BANDS;
		param->band_1 = 1;
		param->band_2 = 2;
		param->band_3 = 3;
		param->band_4 = 4;
		param->band_5 = 0;
	} else {
		param->bands	= prefs.bands;
		param->band_1	= prefs.band_1;
		param->band_2	= prefs.band_2;
		param->band_3	= prefs.band_3;
		param->band_4	= prefs.band_4;
		param->band_5	= prefs.band_5;
	}
	return;
}

static void SaveToPrefs( Param *param )
{
	ResistorDAPreferenceType prefs;
	SystemPreferencesType sysPrefs;

	PrefGetPreferences( &sysPrefs );	
	prefs.bands	= param->bands;
	prefs.band_1 = param->band_1;
	prefs.band_2 = param->band_2;
	prefs.band_3 = param->band_3;
	prefs.band_4 = param->band_4;
	prefs.band_5 = param->band_5;
	PrefSetAppPreferences( ResistorDA_AppID, 0, ResistorDAPrefVersionNum, &prefs, 
			sizeof (ResistorDAPreferenceType), true);
	return;
}

static Boolean isColorDevice( void )
{
	Err error;
	DWord width;
	DWord height;
	DWord depth;
	Boolean	enableColor;

	error = ScrDisplayMode( scrDisplayModeGet, &width, &height, &depth, &enableColor );
	return enableColor;
}

/*  $Revision: 1.7 $
 *
 *  $Log: ResistorDA.c,v $
 *  Revision 1.7  2001/05/02 13:43:37  kterada
 *  add ohm symbol
 *
 *  Revision 1.6  2001/05/01 18:47:46  kterada
 *  omit the first zero
 *
 *  Revision 1.5  2001/05/01 18:37:20  kterada
 *  *** empty log message ***
 *
 *  Revision 1.4  2001/05/01 18:35:19  kterada
 *  add gold/silver offset
 *
 *  Revision 1.3  2001/05/01 18:25:45  kterada
 *  *** empty log message ***
 *
 *  Revision 1.2  2001/05/01 18:03:14  kterada
 *  working version
 *
 *  Revision 1.1.1.1  2001/04/30 17:45:35  kterada
 *  Resistor Calcurater DA
 *
 */

